package app.pivo.android.lightsdk.reply.impl

import app.pivo.android.lightsdk.model.SerialNumber
import app.pivo.android.lightsdk.reply.Reply
import app.pivo.android.lightsdk.util.HexUtil

/**
 * Created by murodjon on 2021/08/29
 */
class SerialNumberReply(private val bytes: ByteArray) : Reply<SerialNumber> {
    override fun getData() =
        getSerialNumber()?.let { SerialNumber(it) }

    private fun getSerialNumber(): String? {
        return if (isSerialNumberReply(bytes)) {
            val sizeOfBytes = bytes.size
            HexUtil.convertHexToSerialNumber(bytes.copyOfRange(3, sizeOfBytes))
        } else null
    }

    companion object {
        fun isSerialNumberReply(bytes: ByteArray) =
            bytes.size >= 15 && bytes[2] == 0x1C.toByte()
    }
}