package app.pivo.android.micsdk

import android.content.Context
import app.pivo.android.micsdk.controller.ble.BluetoothControllerImpl
import app.pivo.android.micsdk.controller.cmd.parser.ReplyHandler
import app.pivo.android.micsdk.controller.mic.PivoHeadsetControllerImpl
import app.pivo.android.micsdk.util.*

/**
 * Created by murodjon on 2021/01/19
 */
class PivoMicSdk constructor(context: Context) : IPivoMicSdk {

    private var controller: PivoHeadsetControllerImpl? = null

    init {
        controller = PivoHeadsetControllerImpl
            .Builder()
            .setBluetoothController(BluetoothControllerImpl(context, ReplyHandler()))
            .build()
    }

    companion object {
        private var instance: IPivoMicSdk? = null

        fun getInstance(context: Context): IPivoMicSdk {
            if (instance == null) instance = PivoMicSdk(context)
            return instance!!
        }
    }

    override fun scan() {
        controller?.scan()
    }

    override fun connectTo(headset: PivoMicDevice) {
        controller?.connectTo(headset)
    }

    override fun cancelScan() {
        controller?.stopScan()
    }

    override fun disconnect() {
        controller?.disconnect()
    }

    override fun changeName(name: String) {
        controller?.changeName(name)
    }

    override fun getDeviceInfo() {
        controller?.getDeviceInfo()
    }

    override fun requestBatteryLevel() {
        controller?.requestBatteryLevel()
    }

    override fun switchLED(led: LED) {
        controller?.switchLED(led)
    }

    override fun switchNoise(noise: Noise) {
        controller?.switchNoise(noise)
    }

    override fun switchSound(sound: Sound) {
        controller?.switchSound(sound)
    }

    override fun requestMacAddress() {
        controller?.requestMacAddress()
    }

    override fun requestSerialNumber() {
        controller?.requestSerialNumber()
    }

    override fun getDeviceStatus() {
        controller?.getMicStatus()
    }

    override fun selectMicMode(micMode: MicMode) {
        controller?.selectMicMode(micMode)
    }

    override fun setBypassMode(mode: Bypass) {
        controller?.setBypassMode(mode)
    }

    override fun isConnected(): Boolean = controller?.isConnected() ?: false

    override fun getName(): String? {
        return controller?.getName()
    }
}