package app.pivo.android.micsdk.controller.cmd.parser

import app.pivo.android.micsdk.util.*

/**
 * Created by murodjon on 2021/01/26
 *
 * This [ReplyChecker] interface has all reply command functions.
 */

internal interface ReplyChecker
    : BatteryLevelChecker, DeviceInfoChecker,
    LEDControlChecker, NoiseCntrlChecker,
    SoundCntrlChecker, MacAddressChecker,
    SerialNumberChecker, NameChangedChecker,
    HeadsetNotificationChecker,
    DeviceStatusChecker, MicSelectorChecker,
    BypassStatusChecker

internal interface BatteryLevelChecker {
    fun getBatteryLevel(): Int?
}

internal interface DeviceInfoChecker {
    fun getDeviceInfo(): DeviceInfo?
}

internal interface LEDControlChecker {
    fun getLED(): LED?
}

internal interface NoiseCntrlChecker {
    fun getNoise(): Noise?
}

internal interface SoundCntrlChecker {
    fun getSound(): Sound?
}

internal interface MicSelectorChecker {
    fun getMicMode(): MicMode?
}

internal interface MacAddressChecker {
    fun getMacAddress(): String?
}

internal interface SerialNumberChecker {
    fun getSerialNum(): String?
}

internal interface NameChangedChecker {
    fun getName(): String?
}

internal interface HeadsetNotificationChecker {
    fun getEventType(): HeadsetNotification?
}

internal interface DeviceStatusChecker {
    fun getDeviceStatus(): DeviceStatus?
}

internal interface BypassStatusChecker {
    fun getBypassStatus(): Bypass?
}