package app.pivo.android.micsdk.controller.mic

import app.pivo.android.micsdk.controller.ble.BluetoothController
import app.pivo.android.micsdk.controller.cmd.CommandUtil
import app.pivo.android.micsdk.util.*

/**
 * Created by murodjon on 2021/01/19
 */
internal class PivoHeadsetControllerImpl : PivoHeadsetController {

    private var bluetoothController: BluetoothController? = null

    internal class Builder {

        private val controller = PivoHeadsetControllerImpl()

        fun setBluetoothController(bleController: BluetoothController): Builder {
            controller.bluetoothController = bleController
            return this
        }

        fun build(): PivoHeadsetControllerImpl {
            return controller
        }
    }

    override fun scan() {
        bluetoothController?.scan()
    }

    override fun connectTo(headset: PivoMicDevice) {
        bluetoothController?.connectTo(headset)
    }

    override fun stopScan() {
        bluetoothController?.cancelScan()
    }

    override fun disconnect() {
        bluetoothController?.disconnect()
    }

    override fun isConnected(): Boolean {
        return bluetoothController?.isConnected() ?: false
    }

    override fun getName(): String? {
        return bluetoothController?.getHeadset()?.getName()
    }

    override fun getDeviceInfo() {
        bluetoothController?.write(CommandUtil.getDeviceInfoBytes())
    }

    override fun getMicStatus() {
        bluetoothController?.write(CommandUtil.getDeviceStatusBytes())
    }

    override fun changeName(name: String) {
        if (name.isNotEmpty()) {
            CommandUtil.getChangeNameBytes(name)?.let { bluetoothController?.write(it) }
        }
    }

    override fun requestBatteryLevel() {
        bluetoothController?.write(CommandUtil.getBatteryLevelBytes())
    }

    override fun switchLED(led: LED) {
        bluetoothController?.write(CommandUtil.getLEDControlBytes(led))
    }

    override fun switchNoise(noise: Noise) {
        bluetoothController?.write(CommandUtil.getNoiseControlBytes(noise))
    }

    override fun switchSound(sound: Sound) {
        bluetoothController?.write(CommandUtil.getSoundControlBytes(sound))
    }

    override fun requestMacAddress() {
        bluetoothController?.write(CommandUtil.getMacAddressBytes())
    }

    override fun requestSerialNumber() {
        bluetoothController?.write(CommandUtil.getSerialNumberBytes())
    }

    override fun selectMicMode(micMode: MicMode) {
        bluetoothController?.write(CommandUtil.selectMicMode(micMode))
    }

    override fun setBypassMode(bypass: Bypass) {
        bluetoothController?.write(CommandUtil.setBypassMode(bypass))
    }

    private fun convertHexToString(data: ByteArray): String {
        val stringBuilder = StringBuilder(data.size)
        for (byteChar in data) stringBuilder.append(String.format("%02X ", byteChar))
        return stringBuilder.toString()
    }
}