package app.pivo.android.micsdk.controller.cmd.parser

import app.pivo.android.micsdk.util.*

/**
 * Created by murodjon on 2021/01/26
 *
 * This [ReplyChecker] interface has all reply command functions.
 */

interface ReplyChecker
    : BatteryLevelChecker, DeviceInfoChecker,
    LEDControlChecker, NoiseCntrlChecker,
    SoundCntrlChecker, MacAddressChecker,
    SerialNumberChecker, NameChangedChecker,
    HeadsetNotificationChecker,
    DeviceStatusChecker, MicSelectorChecker,
    BypassStatusChecker

interface BatteryLevelChecker {
    fun getBatteryLevel(): Int?
}

interface DeviceInfoChecker {
    fun getDeviceInfo(): DeviceInfo?
}

interface LEDControlChecker {
    fun getLED(): LED?
}

interface NoiseCntrlChecker {
    fun getNoise(): Noise?
}

interface SoundCntrlChecker {
    fun getSound(): Sound?
}

interface MicSelectorChecker {
    fun getMicMode(): MicMode?
}

interface MacAddressChecker {
    fun getMacAddress(): String?
}

interface SerialNumberChecker {
    fun getSerialNum(): String?
}

interface NameChangedChecker {
    fun getName(): String?
}

interface HeadsetNotificationChecker {
    fun getEventType(): HeadsetNotification?
}

interface DeviceStatusChecker {
    fun getDeviceStatus(): DeviceStatus?
}

interface BypassStatusChecker {
    fun getBypassStatus(): Bypass?
}