package app.pivo.android.micsdk.controller.mic

import app.pivo.android.micsdk.util.*

/**
 * Created by murodjon on 2021/01/19
 */
interface PivoMicController {


    /**
     * This function is used to scan for Pivo headset
     */
    fun scan()

    /**
     * This function is used to connect to the device.
     * @param headset is the headset, you want to connect to
     */
    fun connectTo(headset: PivoMicDevice)

    /**
     * Call this function to stop scanning
     */
    fun stopScan()

    /**
     * Call this function to disconnect
     */
    fun disconnect()

    fun setConnectionOnOffLastDevice(isOn: Boolean)

    /**
     * This function is used to change Headset name
     * @param name is desired
     */
    fun changeName(name: String)

    /**
     * This function is used to get device info
     */
    fun getDeviceInfo()

    /**
     * This function is used to get device status
     */
    fun getMicStatus()

    /**
     * This function is used to request battery
     */
    fun requestBatteryLevel()

    /**
     * This function controls LED
     */
    fun switchLED(led: LED)

    /**
     * This function controls noise
     */
    fun switchNoise(noise: Noise)

    /**
     * This function controls sound
     */
    fun switchSound(sound: Sound)

    /**
     * This functions is used request macAddress of headset
     */
    fun requestMacAddress()

    /**
     * This function is used to request serial number of headset
     */
    fun requestSerialNumber()

    /**
     * This function is used to check if the device is connected to headset
     */
    fun isConnected(): Boolean

    /**
     * This function is used to get name
     */
    fun getName():String?

    /**
     * This function is used to select the mic and set mode
     */
    fun selectMicMode(micMode: MicMode)

    /**
     * This function is used to set bypass mode
     */
    fun setBypassMode(bypass: Bypass)
}