package app.pivo.android.micsdk.util

/**
 * Created by murodjon on 2021/01/19
 */
interface IPivoMicSdk {

    /**
     * This function is used to scan for Pivo headset
     */
    fun scan()

    /**
     * This function is used to connect to the device.
     * @param headset is the headset, you want to connect to
     */
    fun connectTo(headset: PivoMicDevice)

    /**
     * Call this function to cancel scanning
     */
    fun cancelScan()

    /**
     * Call this function to disconnect
     */
    fun disconnect()

    fun setConnectionOnOffLastDevice(isOn: Boolean)

    /**
     * This function is used to change Headset name
     * @param name is desired
     */
    fun changeName(name: String)

    /**
     * This function is used to get device info
     */
    fun getDeviceInfo()

    /**
     * This function is used to request battery
     */
    fun requestBatteryLevel()

    /**
     * This function controls LED
     */
    fun switchLED(led: LED)

    /**
     * This function controls noise
     */
    fun switchNoise(noise: Noise)

    /**
     * This function controls sound
     */
    fun switchSound(sound: Sound)

    /**
     * This functions is used request macAddress of headset
     */
    fun requestMacAddress()

    /**
     * This function is used to request serial number of headset
     */
    fun requestSerialNumber()

    /**
     * This function is used to check if the device is connected to headset
     */
    fun isConnected(): Boolean

    /**
     * This function is used to get Pivo mic name
     */
    fun getName(): String?

    /**
     * This function is used to get device status
     */
    fun getDeviceStatus()

    /**
     * This function is used to select mic mode
     */
    fun selectMicMode(micMode: MicMode)

    /**
     * This function is used to set bypass mode
     */
    fun setBypassMode(mode: Bypass)
}