package app.pivo.android.plussdk;

import android.app.ActivityManager;
import android.content.Context;
import android.util.Log;

class RamClassifier {

    private static String TAG = "RamClassifier";

    static Class classify(Context context){
        ActivityManager activityManager=(ActivityManager) context.getSystemService(Context.ACTIVITY_SERVICE);
        ActivityManager.MemoryInfo memoryInfo=new ActivityManager.MemoryInfo();
        activityManager.getMemoryInfo(memoryInfo);

        float totalRam = (float)memoryInfo.totalMem / (1024f*1024f);
        Log.i(TAG, "total RAM: "+ totalRam);

        float availRam = (float)memoryInfo.availMem / (1024f*1024f);
        Log.i(TAG, "available RAM: "+ availRam);

        if (totalRam < 3000f) {
            if (availRam < 800f) {
                return Class.C1;
            }
            else {
                return Class.C2;
            }
        }
        else if (totalRam < 4000f) {
            if (availRam < 1400f) {
                return Class.B1;
            }
            else {
                return Class.B2;
            }
        }
        else {
            return Class.A1;
        }
    }

    public static float getAvailRamMB(Context context){
        ActivityManager activityManager=(ActivityManager) context.getSystemService(Context.ACTIVITY_SERVICE);
        ActivityManager.MemoryInfo memoryInfo=new ActivityManager.MemoryInfo();
        activityManager.getMemoryInfo(memoryInfo);
        float availableMemory = (float)memoryInfo.availMem / (1024f*1024f);

        Log.i(TAG, "available RAM: "+ availableMemory);

        return availableMemory;
    }

    public enum Class{
        C1(1),
        C2(2),
        B1(3),
        B2(4),
        A1(5);
        Class(int value){
            this.value = value;
        }
        int value;

        public int getValue(){
            return value;
        }

        public boolean A1(){
            return A1.value == value;
        }

        public boolean B2(){
            return B2.value == value;
        }

        public boolean B1(){
            return B1.value == value;
        }

        public boolean C2(){
            return C2.value == value;
        }

        public boolean C1(){
            return C1.value == value;
        }
    }

}
