package app.pivo.android.plussdk.util;

import android.graphics.Rect;

/**
 * Created by murodjon on 2020/04/14
 */
public interface ITrackingListener{
    /**
     * This callback function is a return of object tracking
     * @param x starting coordinate point of tracked result by x
     * @param y starting coordinate of tracked result by y
     * @param width width of tracked object
     * @param height height of tracked object
     */
    default void onTracking(int x, int y, int width, int height){}

    /**
     * This callback function is a return of object tracking
     * @param x starting coordinate point of tracked result by x
     * @param y starting coordinate of tracked result by y
     * @param width width of tracked object
     * @param height height of tracked object
     * @param frameWidth width of being processed frame
     * @param frameHeight height of being processed frame
     */
    default void onTracking(int x, int y, int width, int height, int frameWidth, int frameHeight){}

    default void onTracking(Rect rect){}

    default void onClear(){}
}
