package app.pivo.android.plussdk.controller

import app.pivo.android.plussdk.controller.model.PDValues
import app.pivo.android.plussdk.controller.model.TwoDimensional

interface SensitivityConfiguration {
    /**
     * Minimum speeds in both axes (X,Y) for PIVO
     */
    fun getMinSpeed(): TwoDimensional<Float>

    /**
     * Maximum speeds in both axes (X,Y)  for PIVO
     */
    fun getMaxSpeed(): TwoDimensional<Float>

    /**
     * Pair of range of speed in deg/sec for in both directions (X,Y)
     */
    fun getRangeSpeed(): TwoDimensional<Float>

    fun getHPDValues(): PDValues

    fun getVPDValues(): PDValues

    fun getPDValues(): TwoDimensional<PDValues>
}
