package app.pivo.android.plussdk.controller.model

data class TwoDimensional<T>(
    var x: T,
    var y: T
)

enum class Dimension {
    X, Y
}

internal infix fun <T> TwoDimensional<T>.getDimensionOfInterest(dimension: Dimension): T {
    return if (dimension == Dimension.X) this.x else this.y
}

operator fun TwoDimensional<Float>.minus(other: TwoDimensional<Float>) =
    TwoDimensional((this.x - other.x), (this.y - other.y))

operator fun TwoDimensional<Float>.plus(other: TwoDimensional<Float>) =
    TwoDimensional(this.x + other.x, this.y + other.y)

operator fun TwoDimensional<Float>.div(other: TwoDimensional<Float>) =
    TwoDimensional(this.x / other.x, this.y / other.y)

operator fun TwoDimensional<Float>.times(num: Int) =
    TwoDimensional(this.x * num, this.y * num)
