// Copyright 2018 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
package app.pivo.android.plussdk.tracking;

/** Describing a frame info. */
public class FrameMetadata {

  private final int width;
  private final int height;
  private int layoutWidth;
  private int layoutHeight;
  private final int rotation;
  private final boolean frontCamera;
  private final boolean orientationLocked;

  public int getLayoutWidth(){
      return layoutWidth;
  }

  public int getLayoutHeight(){
      return layoutHeight;
  }

  public int getWidth() {
    return width;
  }

  public int getHeight() {
    return height;
  }

  public int getRotation() {
    return rotation;
  }

  public boolean isFrontCamera() {
    return frontCamera;
  }

  public boolean isOrientationLocked(){
    return orientationLocked;
  }

  private FrameMetadata(int width, int height, int layoutWidth, int layoutHeight, int rotation, boolean frontCamera, boolean orientationLocked) {
    this.width = width;
    this.height = height;
    this.layoutWidth = layoutWidth;
    this.layoutHeight = layoutHeight;
    this.rotation = rotation;
    this.frontCamera = frontCamera;
    this.orientationLocked = orientationLocked;
  }

  /** Builder of {@link FrameMetadata}. */
  public static class Builder {

    private int layoutWidth;
    private int layoutHeight;
    private int width;
    private int height;
    private int rotation;
    private boolean frontCamera;
    private boolean orientationLocked;

    public Builder setWidth(int width) {
      this.width = width;
      return this;
    }

    public Builder setHeight(int height) {
      this.height = height;
      return this;
    }

    public Builder setLayoutWidth(int layoutWidth) {
      this.layoutWidth = layoutWidth;
      return this;
    }

    public Builder setLayoutHeight(int layoutHeight) {
      this.layoutHeight = layoutHeight;
      return this;
    }

    public Builder setRotation(int rotation) {
      this.rotation = rotation;
      return this;
    }

    public Builder setCameraFacing(boolean frontCamera) {
      this.frontCamera = frontCamera;
      return this;
    }

    public Builder setOrientationLocked(boolean locked){
      this.orientationLocked = locked;
      return this;
    }

    public FrameMetadata build() {
      return new FrameMetadata(width, height, layoutWidth, layoutHeight, rotation, frontCamera, orientationLocked);
    }
  }
}
