package app.pivo.android.podsdk.cmd.builder.factory.impl

import app.pivo.android.podsdk.cmd.builder.CommandBuilder
import app.pivo.android.podsdk.cmd.builder.factory.CommandBuilderFactory
import app.pivo.android.podsdk.cmd.builder.impl.PodCmdBuilderImpl
import app.pivo.android.podsdk.cmd.builder.impl.PodMaxBuilderImpl
import app.pivo.android.podsdk.cmd.builder.impl.PodXCmdBuilderImpl
import app.pivo.android.podsdk.model.PivoDeviceType

/**
 * Created by murodjon on 2022/01/13
 */
internal class CommandBuilderFactoryImpl(private val podType: PivoDeviceType) :
    CommandBuilderFactory {
    override fun getCommandBuilder(): CommandBuilder {
        return when (podType) {
            PivoDeviceType.POD -> PodCmdBuilderImpl()
            PivoDeviceType.POD_X -> PodXCmdBuilderImpl()
            PivoDeviceType.POD_MAX -> PodMaxBuilderImpl()
            PivoDeviceType.POD_REMOTE -> PodXCmdBuilderImpl()
        }
    }
}