package app.pivo.android.podsdk.cmd.parser.impl.podx

import app.pivo.android.podsdk.model.MixedDirection
import app.pivo.android.podsdk.model.MixedMovement
import app.pivo.android.podsdk.cmd.parser.impl.Reply
import app.pivo.android.podsdk.util.HexUtil

/**
 * Created by murodjon on 2021/07/13
 */
class MixedMovementReply(private val bytes: ByteArray) : Reply<MixedMovement> {

    override fun getData(): MixedMovement? {
        return if (isMixedMovementReply(bytes)) {
            val direction = when (bytes[4]) {
                0x41.toByte() -> MixedDirection.RIGHT_UP
                0x42.toByte() -> MixedDirection.RIGHT_DOWN
                0x43.toByte() -> MixedDirection.LEFT_UP
                else -> MixedDirection.LEFT_DOWN
            }
            val hSpeed = HexUtil.convertHexBytesToInt(byteArrayOf(bytes[6], bytes[7]))
            val hDegree = HexUtil.convertHexBytesToInt(byteArrayOf(bytes[8], bytes[9]))
            val vSpeed = HexUtil.convertHexBytesToInt(byteArrayOf(bytes[10], bytes[11]))
            val vDegree = bytes[12].toInt()
            MixedMovement(
                mixedMovementDirection = direction,
                verticalSpeed = vSpeed,
                verticalDegree = vDegree,
                horizontalSpeed = hSpeed,
                horizontalDegree = hDegree
            )
        } else {
            null
        }
    }

    companion object {
        fun isMixedMovementReply(bytes: ByteArray) = bytes.size == 13 &&
                bytes[3] == 0x4D.toByte() &&
                (bytes[4] == 0x41.toByte()
                        || bytes[4] == 0x42.toByte()
                        || bytes[4] == 0x43.toByte()
                        || bytes[4] == 0x44.toByte())
    }
}
