package app.pivo.android.podsdk.model

import app.pivo.android.podsdk.auth.AuthState
import app.pivo.android.podsdk.ota.FirmwareUpdateState

/**
 * Created by murodjon on 2022/01/13
 */
internal sealed class PivoEvent {

    data class FirmwareUpdateEvent(val firmwareUpdateState: FirmwareUpdateState) : PivoEvent()

    data class DeviceInfoEvent(val deviceInfo: DeviceInfo) : PivoEvent()

    data class AuthenticationEvent(val state: AuthState) : PivoEvent()

    data class ConnectionTimeOutEvent(val timeOut: ConnectionTimeOut) : PivoEvent()

    data class BatteryEvent(val battery: Battery) : PivoEvent()

    data class SoundEvent(val sound: Sound) : PivoEvent()

    data class RemoteConPairingEvent(val pairing: Pairing) : PivoEvent()

    object Stop : PivoEvent()

    data class HorizontalMovementEvent(
        val movement: HorizontalMovement
    ) : PivoEvent()

    data class HorizontalPositionEvent(
        val horizontalPosition: HorizontalPosition
    ) : PivoEvent()

    data class GoToHorizontalPositionEvent(
        val goToHorizontalPosition: GoToHorizontalPosition
    ) : PivoEvent()

    data class SpeedEvent(
        val speed: ChangedSpeed
    ) : PivoEvent()

    object HorizontalResetToOrigin : PivoEvent()

    data class VerticalMovementEvent(
        val movement: VerticalMovement
    ) : PivoEvent()

    data class VerticalPositionEvent(
        val verticalPosition: VerticalPosition
    ) : PivoEvent()

    data class GoToVerticalPositionEvent(
        val verticalPosition: GoToVerticalPosition
    ) : PivoEvent()

    data class MixedMovementEvent(
        val mixedMovement: MixedMovement
    ) : PivoEvent()

    data class RemoteConBypassEvent(val bypass: RemoteConBypass) : PivoEvent()

    data class NameChangedEvent(val name: Name) : PivoEvent()

    data class RemoteConButtonEvent(val remoteConButton: RemoteConButton) : PivoEvent()

    data class LEDSetEvent(
        val led: SetLED
    ) : PivoEvent()

    data class CurrentLEDEvent(
        val led: CurrentLED
    ):PivoEvent()

    data class LEDPresetEvent(
        val patternType: LightPatternType,
        val brightnessLevel: Int
    ) : PivoEvent()

    object LEDStopPreset : PivoEvent()

    data class MacAddressEvent(val macAddress: MacAddress) : PivoEvent()

    data class SerialNumberEvent(val serialNumber: SerialNumber) : PivoEvent()

    data class NotifierEvent(
        val notifier: Notifier
    ) : PivoEvent()

    data class InvalidReplyEvent(val bytes: ByteArray) : PivoEvent()
}