package app.pivo.android.podsdk.cmd.parser.impl.pod

import app.pivo.android.podsdk.model.HorizontalDirection
import app.pivo.android.podsdk.model.HorizontalMovement
import app.pivo.android.podsdk.cmd.parser.impl.Reply
import app.pivo.android.podsdk.cmd.parser.impl.pod.RemoteControllerReply.Companion.getSpeed
import app.pivo.android.podsdk.model.Speed
import app.pivo.android.podsdk.model.SpeedUnit

/**
 * Created by murodjon on 2021/05/28
 */
class HorizontalMovementReply(private val bytes: ByteArray) : Reply<HorizontalMovement> {
    override fun getData(): HorizontalMovement? {
        return if (isHorizontalMovementReply(bytes)) {
            getHorizontalMovement()
        } else
            null
    }

    private fun getHorizontalMovement(): HorizontalMovement {
        val direction = if (isRight(bytes[2])) {
            HorizontalDirection.RIGHT
        } else {
            HorizontalDirection.LEFT
        }

        var speed = 0
        var rotationDegree = 0

        val directionByte = bytes[2]
        when {
            isMovementRight_New_4(directionByte) || isMovementLeft_New_4(directionByte) -> {
                speed = bytes[3].toInt() * 2
                rotationDegree = bytes[5].toInt() * 4
            }
            isMovementRight_New_1(directionByte) || isMovementLeft_New_1(directionByte) -> {
                speed = bytes[3].toInt() * 2
                rotationDegree = bytes[5].toInt()
            }
            isMovementLeft_Legacy_4(directionByte) || isMovementRight_Legacy_4(directionByte) -> {
                speed = getSpeed(bytes[3]) ?: 0
                rotationDegree = bytes[5].toInt() * 4
            }
            isMovementRight_Legacy_1(directionByte) || isMovementLeft_Legacy_1(directionByte) -> {
                speed = getSpeed(bytes[3]) ?: 0
                rotationDegree = bytes[5].toInt()
            }
        }

        return HorizontalMovement(
            direction = direction,
            speed = Speed(speed, SpeedUnit.SEC_PER_ROUND),
            rotationDegree = rotationDegree
        )
    }

    private fun isRight(byte: Byte) = isMovementRight_New_4(byte)
            || isMovementRight_New_1(byte)
            || isMovementRight_Legacy_4(byte)
            || isMovementRight_Legacy_1(byte)

    private fun isLeft(byte: Byte) = isMovementLeft_New_4(byte)
            || isMovementLeft_New_1(byte)
            || isMovementLeft_Legacy_4(byte)
            || isMovementLeft_Legacy_1(byte)


    private fun isMovementRight_New_4(byte: Byte) = byte == 0x22.toByte()
    private fun isMovementRight_New_1(byte: Byte) = byte == 0x26.toByte()

    private fun isMovementLeft_New_4(byte: Byte) = byte == 0x24.toByte()
    private fun isMovementLeft_New_1(byte: Byte) = byte == 0x28.toByte()

    private fun isMovementRight_Legacy_4(byte: Byte) = byte == 0x21.toByte()
    private fun isMovementRight_Legacy_1(byte: Byte) = byte == 0x25.toByte()

    private fun isMovementLeft_Legacy_4(byte: Byte) = byte == 0x23.toByte()
    private fun isMovementLeft_Legacy_1(byte: Byte) = byte == 0x27.toByte()

    companion object {
        fun isHorizontalMovementReply(bytes: ByteArray) = bytes.size == 6 &&
                (bytes[2] == 0x21.toByte()
                        || bytes[2] == 0x22.toByte()
                        || bytes[2] == 0x23.toByte()
                        || bytes[2] == 0x24.toByte()
                        || bytes[2] == 0x25.toByte()
                        || bytes[2] == 0x26.toByte()
                        || bytes[2] == 0x27.toByte()
                        || bytes[2] == 0x28.toByte())
    }
}