package app.pivo.android.podsdk

import app.pivo.android.podsdk.model.*
import app.pivo.android.podsdk.model.callback.OnPodRegisteredListener

/**
 * Created by murodjon on 2022/01/12
 */
interface IPodSdk : OnPodRegisteredListener {
    /**
     * This function[scan] is used to scan ble pod devices
     */
    fun scan()

    /**
     * This function[cancelScan] cancels scanning ble devices
     */
    fun cancelScan()

    /**
     * This function[disconnect] disconnects from ble devices
     */
    fun disconnect()

    /**
     * This function [isConnected] checks connectivity of devices
     */
    fun isConnected(): Boolean

    /**
     * This function [connectTo] is used to connect to the device
     */
    fun connectTo(device: PivoDevice)

    /**
     * This [move] function's supported on PodX
     */
    fun move(
        direction: MixedDirection,
        verticalSpeed: Speed,
        verticalDegree: Int,
        horizontalSpeed: Speed,
        horizontalDegree: Int
    )

    /**
     * This [resetPosition] function is supported on PodX
     */
    fun resetPosition()

    /**
     * This [moveVertically] function is supported on PodX
     */
    fun moveVertically(direction: VerticalDirection, degree: Int, speed: Speed)

    fun moveHorizontally(direction: HorizontalDirection, degree: Int, speed: Speed)

    fun moveHorizontallyContinuously(direction: HorizontalDirection, speed: Speed)

    fun getHorizontalSpeedsInSecPerRound(): IntArray

    fun stop()

    fun getDeviceInfo(): DeviceInfo?

    fun requestDeviceInfo()

    fun requestMacAddress()

    fun requestSerialNumber()

    fun requestBattery()

    fun changeName(name: String)

    fun setSpeedForVertical(speed: Speed)

    fun setSpeedForHorizontal(speed: Speed)

    fun goToVerticalPosition(speed: Speed, degree: Int)

    fun gotoHorizontalPosition(speed: Speed, degree: Int)

    /**
     * This [resetHorizontalPosition] function is supported on PodX
     */
    fun resetHorizontalPosition()

    /**
     * This [getVerticalPosition] function is supported on PodX
     */
    fun getVerticalPosition()

    /**
     * This [getHorizontalPosition] function is supported on PodX
     */
    fun getHorizontalPosition()

    /**
     * This [getCurrentLEDColors] function is supported on PodX
     */
    fun getCurrentLEDColors()

    /**
     * This [setLEDColor] function is supported on PodX
     */
    fun setLEDColor(colors: CurrentLED)

    /**
     *  Applies light preset
     */
    fun runLightPreset(patternType: LightPatternType, level: Int)

    /**
     * Stops light preset
     */
    fun stopLightPreset()

    fun makeSound(sound: SoundType)

    fun setConnectionTimeout(timeInSecond: Int)

    fun enableRemoteController(enabled: Boolean)

    fun enableNotifier(enabled: Boolean)

    fun startPairing()

    fun cancelPairing()

    fun upgradeFirmware(bytes: ByteArray, otaPacketSize: Int)

    fun authenticatePod(wrongAuthentication: Boolean)
}