package app.pivo.android.podsdk.model

/**
 * Created by murodjon on 2021/09/06
 */
sealed class RemoteConButton {
    data class Mode(val pressed: Boolean) : RemoteConButton()
    data class OK(val pressed: Boolean) : RemoteConButton()
    data class Pause(val pressed: Boolean) : RemoteConButton()
    data class LeftContinuous(val pressed: Boolean) : RemoteConButton()
    data class RightContinuous(val pressed: Boolean) : RemoteConButton()
    data class Left(val pressed: Boolean) : RemoteConButton()
    data class Right(val pressed: Boolean) : RemoteConButton()
    data class SpeedChange(val pressed: Boolean, val buttonType: ButtonType, val speed: Int) :
        RemoteConButton()
    data class TiltUp(val pressed: Boolean) : RemoteConButton()
    data class TiltDown(val pressed: Boolean) : RemoteConButton()
    object OFF : RemoteConButton()
}

