package app.pivo.android.podsdk.cmd.builder

import app.pivo.android.podsdk.model.*

/**
 * Created by murodjon on 2021/05/20
 */
internal interface CommandBuilder {

    /**
     * Gets check connection bytes
     */
    fun getDeviceInfoBytes(): ByteArray

    /**
     * Gets battery level bytes
     */
    fun getBatteryLevelBytes(): ByteArray

    /**
     * Gets change name bytes
     * @param name is new name for headset
     * @return an array of byte values is returned from function
     */
    fun getChangeNameBytes(name: String): ByteArray?

    /**
     * Gets mac address requester bytes
     * @return an array of byte values
     */
    fun getMacAddressBytes(): ByteArray

    /**
     * Gets serial number requester bytes
     */
    fun getSerialNumberBytes(): ByteArray

    /**
     * This function returns remote controller switcher bytes according to
     * @param remoteEnabled is true when remote controller and pod communicates
     */
    fun getRemoteSwitcherBytes(remoteEnabled: Boolean): ByteArray

    /**
     * Gets timeout bytes
     */
    fun getTimeoutBytes(time: Int): ByteArray

    /**
     * This function returns sound command bytes according to sound type
     * @param sound is predefined sound type
     */
    fun getSoundBytes(sound: SoundType): ByteArray

    /**
     * This function is used to enable and disable notifier according
     * @param notifierEnabled notifier is enabled when notifierEnabled true
     */
    fun getNotifierSwitcherBytes(notifierEnabled: Boolean): ByteArray

    /**
     * get horizontal movement bytes
     * @param speed is speed for horizontal
     * @param degree is rotation degree
     * @param direction is direction of movement
     */
    fun getMoveHorizontallyBytes(
        version: Int,
        direction: HorizontalDirection,
        speed: Speed,
        degree: Int
    ): ByteArray?

    fun getMoveVerticallyBytes(
        direction: VerticalDirection,
        speed: Speed,
        degree: Int
    ): ByteArray? {
        return null
    }

    /**
     * get Moving combination bytes
     *
     * @param hDirection is horizontal movement direction
     * @param hSpeed is horizontal movement speed
     * @param hDegree is horizontal movement degree
     *
     * @param vlDirection is vertical movement direction
     * @param vSpeed is vertical movement speed
     * @param vDegree is vertical movement rotation degree
     */
    fun getMovingCombinationBytes(
        hSpeed: Speed,
        hDegree: Int,
        vSpeed: Speed,
        vDegree: Int,
        mixedDirection: MixedDirection
    ): ByteArray? {
        return null
    }

    /**
     * get vertical movement bytes
     * @param speed is speed for vertical movement
     * @param degree is rotation degree
     * @param direction is moving direction
     */
    fun getVerticalPositionBytes(): ByteArray? {
        return null
    }

    /**
     * This returns bytes for getting horizontal position bytes
     */
    fun getHorizontalPositionBytes(): ByteArray? {
        return null
    }

    fun getResetPositionBytes(): ByteArray? {
        return null
    }

    /**
     * This returns bytes to set speed for vertical motor
     * @param speed
     */
    fun getSetVerticalSpeedBytes(speed: Speed): ByteArray? {
        return null
    }

    /**
     * This returns bytes to set speed for horizontal motor
     * @param speed
     */
    fun getSetHorizontalSpeedBytes(version: Int, speed: Speed): ByteArray?

    fun getHorizontalSpeedsSecPerRound(version: Int): IntArray

    /**
     * This returns "go to vertical position" bytes according to speed and degree
     */
    fun getGoToVerticalPositionBytes(speed: Speed, degree: Int): ByteArray? {
        return null
    }

    /**
     * This returns "go to horizontal position" bytes according to speed and degree
     */
    fun getGoToHorizontalPositionBytes(speed: Speed, degree: Int): ByteArray? {
        return null
    }

    /**
     * Gets battery level bytes
     */
    fun getStopBytes(): ByteArray

    fun getStartPairingBytes(): ByteArray

    fun getCancelPairingBytes(): ByteArray

    /**
     * This returns bytes to set LED color based on
     * @param colors
     */
    fun getSetLEDColorBytes(colors: List<LEDColor>, brightness: Int): ByteArray? {
        return null
    }

    /**
     * This returns bytes to retrieve current set LED color
     */
    fun getRetrieveLEDColorBytes(): ByteArray? {
        return null
    }

    /**
     * Returns bytes for applying light presets
     */
    fun getRunLightPresetBytes(patternType: LightPatternType, level:Int): ByteArray? {
        return null
    }

    /**
     * Returns bytes for stopping light presets
     */
    fun getStopLightPresetBytes(): ByteArray? {
        return null
    }

    fun getAuthenticatePodBytes(
        deviceCategory: PivoDeviceCategory,
        seqNum: Byte,
        answerFromPod: Int,
        inquiryFromPod: Int
    ): ByteArray? {
        return null
    }

    fun getOTAInitiationBytes(): ByteArray

    fun getFirmwareFileChunkBytes(firmwareBytes: ByteArray, packetSize: Int = 192): ByteArray

    fun getFirmwareFileChunkBytes(
        firmwareBytes: ByteArray,
        replyBytes: ByteArray,
        packetSize: Int = 192
    ): ByteArray
}