package app.pivo.android.podsdk.model

/**
 * Created by murodjon on 2022/01/10
 */
sealed class PivoDeviceCategory(open var version: Int) {
    data class PivoPod(override var version: Int = 0, var model: PodModel = PodModel.UNDEFINED) :
        PivoDeviceCategory(version)

    data class PivoPodX(override var version: Int = 0) : PivoDeviceCategory(version)
    data class PivoPodMax(override var version: Int = 0) : PivoDeviceCategory(version)
    data class PivoXRemote(override var version: Int = 0) : PivoDeviceCategory(version)

    fun getDeviceCategory() = when (this) {
        is PivoXRemote -> {
            0
        }
        is PivoPod -> {
            1
        }
        is PivoPodX -> {
            2
        }
        is PivoPodMax -> {
            3
        }
    }
}