package app.pivo.android.podsdk.cmd.parser.impl.podx

import app.pivo.android.podsdk.cmd.parser.impl.Reply
import app.pivo.android.podsdk.model.SetLED

/**
 * Created by murodjon on 2022/03/28
 */
class SetLEDReply(private val bytes:ByteArray):Reply<SetLED> {
    override fun getData(): SetLED {
        return SetLED(bytes[6].toInt())
    }

    companion object {
        fun isLEDSetReply(bytes: ByteArray) =
            (bytes.size >= 8 && bytes[4] == 0x40.toByte()
                    && bytes[3] == 0x4C.toByte())
    }
}