package app.pivo.android.podsdk.cmd.parser.impl.podx

import app.pivo.android.podsdk.model.VerticalPosition
import app.pivo.android.podsdk.cmd.parser.impl.Reply

/**
 * Created by murodjon on 2021/05/28
 */
internal class GetVerticalPositionReply(private val bytes: ByteArray) :
    Reply<VerticalPosition> {
    override fun getData(): VerticalPosition? {
        return if (isGetVerticalPositionReply(bytes)) {
            val degree = bytes[6].toInt()
            VerticalPosition(degree)
        } else
            null
    }

    companion object {
        fun isGetVerticalPositionReply(bytes: ByteArray) = bytes.size == 8 &&
                bytes[3] == 0x4D.toByte() &&
                bytes[4] == 0x32.toByte()
    }
}