package app.pivo.android.podsdk.cmd.parser.impl.pod

import app.pivo.android.podsdk.cmd.parser.impl.Reply
import app.pivo.android.podsdk.model.*

/**
 * Created by murodjon on 2021/05/27
 */
internal class DeviceInfoReply constructor(private val bytes: ByteArray) :
    Reply<PivoEvent.DeviceInfoEvent> {

    override fun getData(): PivoEvent.DeviceInfoEvent {
        return PivoEvent.DeviceInfoEvent(
            getDeviceInfo(bytes)
        )
    }

    private fun getDeviceInfo(bytes: ByteArray): DeviceInfo {
        return when (val byte = bytes[3]) {
            // RED
            0x00.toByte() -> DeviceInfo(
                PivoDeviceCategory.PivoPod(
                    version = byte.toInt(),
                    PodModel.RED
                )
            )
            0x01.toByte() -> DeviceInfo(
                PivoDeviceCategory.PivoPod(
                    version = byte.toInt(),
                    PodModel.RED
                )
            )
            0x03.toByte() -> DeviceInfo(
                PivoDeviceCategory.PivoPod(
                    version = byte.toInt(),
                    PodModel.RED
                )
            )
            0x10.toByte() -> DeviceInfo(
                PivoDeviceCategory.PivoPod(
                    version = bytes[5].toInt(),
                    PodModel.RED
                )
            )
            //SILVER
            0x02.toByte() -> DeviceInfo(
                PivoDeviceCategory.PivoPod(
                    version = byte.toInt(),
                    PodModel.SILVER
                )
            )
            0x20.toByte() -> DeviceInfo(
                PivoDeviceCategory.PivoPod(
                    version = bytes[5].toInt(),
                    PodModel.SILVER
                )
            )
            //BLACK
            0x04.toByte() -> DeviceInfo(
                PivoDeviceCategory.PivoPod(
                    version = byte.toInt(),
                    PodModel.BLACK
                )
            )
            0x30.toByte() -> DeviceInfo(
                PivoDeviceCategory.PivoPod(
                    version = bytes[5].toInt(),
                    PodModel.BLACK
                )
            )
            // GOLD
            0x40.toByte() -> DeviceInfo(
                PivoDeviceCategory.PivoPod(
                    version = bytes[5].toInt(),
                    PodModel.GOLD
                )
            )
            // LITE
            0x50.toByte() -> DeviceInfo(
                PivoDeviceCategory.PivoPod(
                    version = bytes[5].toInt(),
                    PodModel.LITE
                )
            )
            else -> DeviceInfo(
                PivoDeviceCategory.PivoPod(
                    version = bytes[5].toInt(),
                    PodModel.UNDEFINED
                )
            )
        }
    }

    companion object {
        fun isDeviceInfoReply(bytes: ByteArray) =
            bytes.size >= 6 && bytes[2] == 0x03.toByte() && bytes[4] == 0x01.toByte()
    }
}