package app.pivo.android.podsdk.uuid

import app.pivo.android.podsdk.model.PivoDeviceType
import app.pivo.android.podsdk.model.PodUUID
import java.util.*

/**
 * Created by murodjon on 2021/08/16
 */
internal val PodUUIDs = mapOf<UUID, PodUUID>(
    //Pivo X - NTek Logic
    UUID.fromString("6e400001-b5a3-f393-e0a9-e50e24dcca9e") to
            PodUUID(// PodX
                serviceUUID = UUID.fromString("6e400001-b5a3-f393-e0a9-e50e24dcca9e"),
                writeUUID = UUID.fromString("6e400002-b5a3-f393-e0a9-e50e24dcca9e"),
                notificationUUID = UUID.fromString("6e400003-b5a3-f393-e0a9-e50e24dcca9e"),
                podType = PivoDeviceType.POD_X
            ),
    //Pivo X - Vita Chinese factory
//    UUID.fromString("0000ca07-0000-1000-8000-00805f5b34db") to
//            PodUUID(// PodX
//                serviceUUID = UUID.fromString("0000ca07-0000-1000-8000-00805f5b34db"),
//                writeUUID = UUID.fromString("0000ca01-0000-1000-8000-00805f5b34db"),
//                notificationUUID = UUID.fromString("0000ca02-0000-1000-8000-00805f5b34db"),
//                podType = PivoDeviceType.POD_X
//            ),
    UUID.fromString("0000ff07-0000-1000-8000-00805f9b34fb") to
            PodUUID(// Pod
                serviceUUID = UUID.fromString("0000ff07-0000-1000-8000-00805f9b34fb"),
                writeUUID = UUID.fromString("0000ff01-0000-1000-8000-00805f9b34fb"),
                notificationUUID = UUID.fromString("0000ff02-0000-1000-8000-00805f9b34fb"),
                podType = PivoDeviceType.POD
            ),
    UUID.fromString("4542CD57-475D-48AB-8CDD-0485AB26A860") to
            PodUUID(// Pod Remote
                serviceUUID = UUID.fromString("4542CD57-475D-48AB-8CDD-0485AB26A860"),
                writeUUID = UUID.fromString("E01BFD43-7BE9-45C2-8397-EA7A61C280D5"),
                notificationUUID = UUID.fromString("96A3448B-8A38-48B4-A4E2-00A6318728FB"),
                podType = PivoDeviceType.POD_REMOTE
            ),
    UUID.fromString("dd24663a-15a8-4457-b112-2bbdddbe25e2") to
            PodUUID(// Pod Max
                serviceUUID = UUID.fromString("dd24663a-15a8-4457-b112-2bbdddbe25e2"),//("6E400001-B5A3-F393-E0A9-E50E24DCCA9E"),
                notificationUUID = UUID.fromString("d6e98572-608a-4d01-883a-dd39Be1071af"),//("6E400003-B5A3-F393-E0A9-E50E24DCCA9E"),
                writeUUID = UUID.fromString("23e6ef69-81b3-4883-96f1-4245beb94fc5"),//("6E400002-B5A3-F393-E0A9-E50E24DCCA9E"),
                podType = PivoDeviceType.POD_MAX
            )
)