package app.pivo.android.podsdk.cmd.parser.impl

import android.util.Log
import app.pivo.android.podsdk.cmd.parser.impl.podx.*
import app.pivo.android.podsdk.cmd.parser.impl.podx.BatteryReply
import app.pivo.android.podsdk.cmd.parser.impl.podx.RemoteConEnabledReply
import app.pivo.android.podsdk.cmd.parser.impl.podx.SoundReply
import app.pivo.android.podsdk.cmd.parser.impl.podx.StopReply
import app.pivo.android.podsdk.model.PivoEvent
import app.pivo.android.podsdk.cmd.parser.ReplyCommandParser
import app.pivo.android.podsdk.cmd.parser.impl.podx.AuthReply
import app.pivo.android.podsdk.cmd.parser.impl.podx.RemoteControllerReply
import app.pivo.android.podsdk.cmd.parser.impl.podx.GetLEDReply
import app.pivo.android.podsdk.cmd.parser.impl.podx.SetLEDReply
import app.pivo.android.podsdk.cmd.parser.impl.podx.LEDRunPresetReply
import app.pivo.android.podsdk.cmd.parser.impl.podx.LEDStopPresetReply
import app.pivo.android.podsdk.cmd.parser.impl.podx.FirmwareUpdateReply
import app.pivo.android.podsdk.model.DeviceInfo
import app.pivo.android.podsdk.model.PivoDevice
import app.pivo.android.podsdk.util.HexUtil

/**
 * Created by murodjon on 2022/01/13
 */
internal class PodXReplyCommandParserImpl(private val podDevice: PivoDevice) : ReplyCommandParser {
    private var deviceInfo: DeviceInfo? = null

    override fun getEvent(bytes: ByteArray): PivoEvent {
        return getType(bytes)
    }

    private fun getType(bytes: ByteArray): PivoEvent {
        return when {
            FirmwareUpdateReply.isOTAProgressReply(bytes) -> {
                PivoEvent.FirmwareUpdateEvent(FirmwareUpdateReply(bytes).getData()!!)
            }
            // basic command set
            DeviceInfoReply.isDeviceInfoReply(bytes) -> {
                val deviceInfo = DeviceInfoReply(bytes).getData()
                this.deviceInfo = deviceInfo
                PivoEvent.DeviceInfoEvent(deviceInfo)
            }
            AuthReply.isAuthNotification(bytes) -> PivoEvent.AuthenticationEvent(AuthReply(bytes).getData())
            ConnectionTimeoutReply.isTimeoutReply(bytes) -> PivoEvent.ConnectionTimeOutEvent(
                ConnectionTimeoutReply(bytes).getData()
            )
            BatteryReply.isBatteryReply(bytes) -> PivoEvent.BatteryEvent(BatteryReply(bytes).getData())
            MacAddressReply.isMacAddressReply(bytes) -> {
                val macAddress = MacAddressReply(bytes).getData()
                if (macAddress == null) {
                    PivoEvent.InvalidReplyEvent(bytes)
                } else {
                    PivoEvent.MacAddressEvent(macAddress)
                }
            }
            SerialNumberReply.isSerialNumberReply(bytes) -> {
                val serialNum = deviceInfo?.getPivoCategory()
                    ?.let { SerialNumberReply(pivoDeviceCategory = it, bytes = bytes).getData() }
                if (serialNum == null) {
                    PivoEvent.InvalidReplyEvent(bytes)
                } else {
                    PivoEvent.SerialNumberEvent(serialNum)
                }
            }

            // movement control command set
            StopReply.isStopReply(bytes) -> PivoEvent.Stop
            // remove controller command set
            RemoteConEnabledReply.isRemoteBypassReply(bytes) -> PivoEvent.RemoteConBypassEvent(
                RemoteConEnabledReply(bytes).getData()
            )
            PairingReply.isPairing(bytes) -> PivoEvent.RemoteConPairingEvent(PairingReply(bytes).getData())

            // Change device name
            NameChangedReply.isNameChangedReply(bytes) -> {
                val name = NameChangedReply(bytes).getData()
                if (name == null) {
                    PivoEvent.InvalidReplyEvent(bytes)
                } else {
                    PivoEvent.NameChangedEvent(name)
                }
            }
            SoundReply.isSoundReply(bytes) -> {
                val sound = SoundReply(bytes).getData()
                if (sound == null) {
                    PivoEvent.InvalidReplyEvent(bytes)
                } else {
                    PivoEvent.SoundEvent(sound)
                }
            }
            NotifierReply.isNotifierReply(bytes) -> PivoEvent.NotifierEvent(NotifierReply(bytes).getData())
            RemoteControllerReply.isRemoteConPressedReply(bytes) -> {
                val remoteCon = RemoteControllerReply(bytes).getData()
                if (remoteCon == null) {
                    PivoEvent.InvalidReplyEvent(bytes)
                } else {
                    PivoEvent.RemoteConButtonEvent(remoteCon)
                }
            }
            HorizontalMovementReply.isHorizontalMovementReply(bytes) -> {
                val movement = HorizontalMovementReply(
                    bytes
                ).getData()
                if (movement == null) {
                    PivoEvent.InvalidReplyEvent(bytes)
                } else {
                    PivoEvent.HorizontalMovementEvent(movement)
                }
            }
            HorizontalSpeedReply.isHorizontalSpeedReply(bytes) -> {
                val speed = HorizontalSpeedReply(bytes).getData()
                if (speed != null) {
                    PivoEvent.SpeedEvent(speed)
                } else {
                    PivoEvent.InvalidReplyEvent(bytes)
                }
            }
            GetHorizontalPositionReply.isGetHorizontalPositionReply(bytes) -> {
                val reply = GetHorizontalPositionReply(
                    bytes
                )
                if (reply.getData() != null) {
                    PivoEvent.HorizontalPositionEvent(reply.getData()!!)
                } else {
                    PivoEvent.InvalidReplyEvent(bytes)
                }
            }
            GoToHorizontalPositionReply.isGoToHorizontalReply(bytes) -> {
                val event = GoToHorizontalPositionReply(
                    bytes
                ).getData()

                if (event != null) {
                    PivoEvent.GoToHorizontalPositionEvent(event!!)
                } else {
                    PivoEvent.InvalidReplyEvent(bytes)
                }
            }
            ResetHorizontalPositionReply.isResetHorizontalReply(bytes) -> {
                val data = ResetHorizontalPositionReply(
                    bytes
                ).getData()
                if (data != null) {
                    PivoEvent.HorizontalResetToOrigin
                } else {
                    PivoEvent.InvalidReplyEvent(bytes)
                }
            }
            VerticalMovementReply.isVerticalMovementReply(bytes) -> {
                val movement = VerticalMovementReply(bytes).getData()
                if (movement != null) {
                    PivoEvent.VerticalMovementEvent(movement!!)
                } else {
                    PivoEvent.InvalidReplyEvent(bytes)
                }
            }
            GetVerticalPositionReply.isGetVerticalPositionReply(bytes) -> {
                val position = GetVerticalPositionReply(
                    bytes
                ).getData()
                if (position != null) {
                    PivoEvent.VerticalPositionEvent(position)
                } else {
                    PivoEvent.InvalidReplyEvent(bytes)
                }
            }
            GoToVerticalPositionReply.isGoToVerticalReply(bytes) -> {
                val position = GoToVerticalPositionReply(bytes).getData()
                if (position != null) {
                    PivoEvent.GoToVerticalPositionEvent(position!!)
                } else {
                    PivoEvent.InvalidReplyEvent(bytes)
                }
            }
            VerticalSpeedReply.isVerticalSpeedReply(bytes) -> {
                Log.e("Parser", "isVerticalSpeedReply")
                val speed = VerticalSpeedReply(bytes).getData()
                if (speed != null) {
                    PivoEvent.SpeedEvent(speed)
                } else {
                    PivoEvent.InvalidReplyEvent(bytes)
                }
            }
            MixedMovementReply.isMixedMovementReply(bytes) -> {
                val movement = MixedMovementReply(bytes).getData()
                if (movement != null) {
                    PivoEvent.MixedMovementEvent(movement!!)
                } else {
                    PivoEvent.InvalidReplyEvent(bytes)
                }
            }
            // LED ring control
            // LED ring control
            GetLEDReply.isLEDReply(bytes) -> {
                val led = GetLEDReply(bytes).getData()
                PivoEvent.CurrentLEDEvent(led)
            }
            SetLEDReply.isLEDSetReply(bytes) -> {
                PivoEvent.LEDSetEvent(SetLEDReply(bytes).getData())
            }
            // LED preset
            LEDStopPresetReply.isLEDStopPresetReply(bytes) -> {
                PivoEvent.LEDStopPreset
            }
            LEDRunPresetReply.isLEDRunPresetReply(bytes) -> {
                val ledRunPreset = LEDRunPresetReply(bytes).getData()
                if (ledRunPreset == null) {
                    PivoEvent.InvalidReplyEvent(bytes)
                } else {
                    PivoEvent.LEDPresetEvent(ledRunPreset.patternType, ledRunPreset.brightnessLevel)
                }
            }
            RemoteControllerReply.isRemoteConPressedReply(bytes) -> {
                val remoteCon = RemoteControllerReply(
                    bytes
                ).getData()
                if (remoteCon == null) {
                    PivoEvent.InvalidReplyEvent(bytes)
                } else {
                    PivoEvent.RemoteConButtonEvent(remoteCon)
                }
            }
            // Change device name
            else -> PivoEvent.InvalidReplyEvent(bytes)
        }
    }
}