package app.pivo.android.podsdk.cmd.parser.impl.podmax

import app.pivo.android.podsdk.cmd.parser.impl.Reply
import app.pivo.android.podsdk.model.ButtonType
import app.pivo.android.podsdk.model.RemoteConButton

/**
 * Created by murodjon on 2022/03/28
 */
class RemoteControllerReply(private val bytes: ByteArray) : Reply<RemoteConButton> {
    override fun getData(): RemoteConButton? {
        var remoteConButton: RemoteConButton? = null

        if (isRemoteConPressedReply(bytes)) {
            val pressed = bytes[6] == 0x00.toByte()
            remoteConButton = when {
                isOK(bytes[4]) -> RemoteConButton.OK(pressed)
                isPanLeft(bytes[4]) -> RemoteConButton.Left(pressed)
                isPanRight(bytes[4]) -> RemoteConButton.Right(pressed)
                isPause(bytes[4]) -> RemoteConButton.Pause(pressed)
                isMode(bytes[4]) -> RemoteConButton.Mode(pressed)
                isSpeedUp(bytes[4]) -> RemoteConButton.SpeedChange(
                    pressed,
                    ButtonType.UP,
                    getSpeed(bytes[7]) ?: 0
                )
                isSpeedDown(bytes[4]) -> RemoteConButton.SpeedChange(
                    pressed,
                    ButtonType.BOTTOM,
                    getSpeed(bytes[7]) ?: 0
                )
                isTiltUp(bytes[4]) -> RemoteConButton.TiltUp(pressed)
                isTiltDown(bytes[4]) -> RemoteConButton.TiltDown(pressed)
                else -> null
            }
        }
        return remoteConButton
    }

    companion object {
        fun isRemoteConPressedReply(bytes: ByteArray) =
            bytes.size >= 8 && bytes[3] == 0x52.toByte() && (
                    isMode(bytes[4]) ||
                            isOK(bytes[4]) ||
                            isPanLeft(bytes[4]) ||
                            isPanRight(bytes[4]) ||
                            isPause(bytes[4]) ||
                            isTiltUp(bytes[4]) ||
                            isTiltDown(bytes[4]) ||
                            isSpeedUp(bytes[4]) ||
                            isSpeedDown(bytes[4]))

        fun getSpeed(byte: Byte): Int? {
            return when (byte) {
                0x01.toByte() -> 60
                0x02.toByte() -> 40
                0x03.toByte() -> 30
                0x04.toByte() -> 20
                0x05.toByte() -> 15
                0x06.toByte() -> 10
                else -> null
            }
        }

        private fun isOK(byte: Byte) = byte == 0x10.toByte()
        private fun isPanLeft(byte: Byte) = byte == 0x11.toByte()
        private fun isPanRight(byte: Byte) = byte == 0x12.toByte()
        private fun isTiltUp(byte: Byte) = byte == 0x13.toByte()
        private fun isTiltDown(byte: Byte) = byte == 0x14.toByte()
        private fun isSpeedDown(byte: Byte) = byte == 0x15.toByte()
        private fun isSpeedUp(byte: Byte) = byte == 0x16.toByte()
        private fun isPause(byte: Byte) = byte == 0x17.toByte()
        private fun isMode(byte: Byte) = byte == 0x18.toByte()
    }
}