package app.pivo.android.podsdk.cmd.parser.impl.podx

import app.pivo.android.podsdk.cmd.parser.impl.Reply
import app.pivo.android.podsdk.model.*
import app.pivo.android.podsdk.util.HexUtil

/**
 * Created by murodjon on 2021/07/13
 */
class MixedMovementReply(private val bytes: ByteArray) : Reply<MixedMovement> {

    override fun getData(): MixedMovement? {
        return if (isMixedMovementReply(bytes)) {
            getMixedMovement()
        } else {
            null
        }
    }

    private fun getMixedMovement(): MixedMovement {
        val hSpeed = HexUtil.convertHexBytesToInt(byteArrayOf(bytes[6], bytes[7]))
        val hDegree = HexUtil.convertHexBytesToInt(byteArrayOf(bytes[8], bytes[9]))
        val vSpeed = HexUtil.convertHexBytesToInt(byteArrayOf(bytes[10], bytes[11]))
        val vDegree = bytes[12].toInt()

        return when (bytes[4]) {
            0x41.toByte() -> MixedMovement(
                mixedMovementDirection = MixedDirection.RIGHT_UP,
                verticalSpeed = Speed(vSpeed, SpeedUnit.SEC_PER_ROUND),
                verticalDegree = vDegree,
                horizontalSpeed = Speed(hSpeed, SpeedUnit.SEC_PER_ROUND),
                horizontalDegree = hDegree
            )
            0x42.toByte() -> MixedMovement(
                mixedMovementDirection = MixedDirection.RIGHT_DOWN,
                verticalSpeed = Speed(vSpeed, SpeedUnit.SEC_PER_ROUND),
                verticalDegree = vDegree,
                horizontalSpeed = Speed(hSpeed, SpeedUnit.SEC_PER_ROUND),
                horizontalDegree = hDegree
            )
            0x43.toByte() -> MixedMovement(
                mixedMovementDirection = MixedDirection.LEFT_UP,
                verticalSpeed = Speed(vSpeed, SpeedUnit.SEC_PER_ROUND),
                verticalDegree = vDegree,
                horizontalSpeed = Speed(hSpeed, SpeedUnit.SEC_PER_ROUND),
                horizontalDegree = hDegree
            )
            0x44.toByte() -> MixedMovement(
                mixedMovementDirection = MixedDirection.LEFT_DOWN,
                verticalSpeed = Speed(vSpeed, SpeedUnit.SEC_PER_ROUND),
                verticalDegree = vDegree,
                horizontalSpeed = Speed(hSpeed, SpeedUnit.SEC_PER_ROUND),
                horizontalDegree = hDegree
            )
            0x81.toByte() -> MixedMovement(
                mixedMovementDirection = MixedDirection.RIGHT_UP,
                verticalSpeed = Speed(vSpeed, SpeedUnit.DEGREE_PER_SEC),
                verticalDegree = vDegree,
                horizontalSpeed = Speed(hSpeed, SpeedUnit.DEGREE_PER_SEC),
                horizontalDegree = hDegree
            )
            0x82.toByte() -> MixedMovement(
                mixedMovementDirection = MixedDirection.RIGHT_DOWN,
                verticalSpeed = Speed(vSpeed, SpeedUnit.DEGREE_PER_SEC),
                verticalDegree = vDegree,
                horizontalSpeed = Speed(hSpeed, SpeedUnit.DEGREE_PER_SEC),
                horizontalDegree = hDegree
            )
            0x83.toByte() -> MixedMovement(
                mixedMovementDirection = MixedDirection.LEFT_UP,
                verticalSpeed = Speed(vSpeed, SpeedUnit.DEGREE_PER_SEC),
                verticalDegree = vDegree,
                horizontalSpeed = Speed(hSpeed, SpeedUnit.DEGREE_PER_SEC),
                horizontalDegree = hDegree
            )
            else -> MixedMovement(
                mixedMovementDirection = MixedDirection.LEFT_DOWN,
                verticalSpeed = Speed(vSpeed, SpeedUnit.DEGREE_PER_SEC),
                verticalDegree = vDegree,
                horizontalSpeed = Speed(hSpeed, SpeedUnit.DEGREE_PER_SEC),
                horizontalDegree = hDegree
            )
        }
    }

    companion object {
        fun isMixedMovementReply(bytes: ByteArray) = bytes.size == 13 &&
                bytes[3] == 0x4D.toByte() &&
                (bytes[4] == 0x41.toByte()
                        || bytes[4] == 0x42.toByte()
                        || bytes[4] == 0x43.toByte()
                        || bytes[4] == 0x44.toByte()
                        || bytes[4] == 0x81.toByte()
                        || bytes[4] == 0x82.toByte()
                        || bytes[4] == 0x83.toByte()
                        || bytes[4] == 0x84.toByte())
    }
}
