package app.pivo.android.podsdk.cmd.parser.impl.podmax

import app.pivo.android.podsdk.auth.AuthState
import app.pivo.android.podsdk.cmd.parser.impl.Reply

/**
 * Created by murodjon on 2022/01/13
 */
internal class AuthReply(private val bytes: ByteArray) : Reply<AuthState> {
    override fun getData(): AuthState {
        return when {
            bytes[6] == 0x01.toByte() -> {
                val inquiry: Int =
                    bytes[8].toInt() and 0xFF shl 24 or
                            (bytes[9].toInt() and 0xFF shl 16) or
                            (bytes[10].toInt() and 0xff shl 8) or
                            (bytes[11].toInt() and 0xff)
                val answer: Int =
                    bytes[12].toInt() and 0xFF shl 24 or
                            (bytes[13].toInt() and 0xff shl 16) or
                            (bytes[14].toInt() and 0xff shl 8) or
                            (bytes[15].toInt() and 0xff)

                AuthState.AuthProgress(answer, inquiry)
            }
            bytes[6] == 0x03.toByte() -> {
                when (bytes[7]) {
                    0x01.toByte() -> AuthState.AuthSucceed// Status 2: Mutual Authentication Success
                    else -> AuthState.AuthFailed
                }
            }
            else -> {
                AuthState.AuthFailed
            }
        }
    }

    companion object {
        fun isAuthNotification(bytes: ByteArray) = bytes.size >= 16 && bytes[4] == 0x6F.toByte()
    }
}