package app.pivo.android.podsdk.cmd.parser.impl.podmax

import app.pivo.android.podsdk.model.MacAddress
import app.pivo.android.podsdk.cmd.parser.impl.Reply
import app.pivo.android.podsdk.util.HexUtil

/**
 * Created by murodjon on 2021/05/27
 */
class MacAddressReply(private val bytes: ByteArray) : Reply<MacAddress> {

    override fun getData() = getMacAddress()?.let { MacAddress(it) }

    private fun getMacAddress(): String? {
        return if (isMacAddressReply(bytes)) {
            HexUtil.convertHexToString(bytes.copyOfRange(6, 12))
        } else null
    }

    companion object {
        fun isMacAddressReply(bytes: ByteArray) =
            bytes.size >= 12
                    && bytes[3] == 0x49.toByte()
                    && bytes[4] == 0x1B.toByte()
    }
}