package app.pivo.android.podsdk.cmd.parser.impl.podx

import app.pivo.android.podsdk.model.GoToHorizontalPosition
import app.pivo.android.podsdk.cmd.parser.impl.Reply
import app.pivo.android.podsdk.model.Speed
import app.pivo.android.podsdk.model.SpeedUnit
import app.pivo.android.podsdk.util.HexUtil

/**
 * Created by murodjon on 2021/07/13
 */
internal class GoToHorizontalPositionReply(private val bytes: ByteArray) :
    Reply<GoToHorizontalPosition> {
    override fun getData(): GoToHorizontalPosition? {
        return if (isGoToHorizontalReply(bytes)) {
            val speedValue = HexUtil.convertHexBytesToInt(byteArrayOf(bytes[6], bytes[7]))
            val speedUnit =
                if (bytes[4] == 0x23.toByte()) SpeedUnit.SEC_PER_ROUND else SpeedUnit.DEGREE_PER_SEC

            GoToHorizontalPosition(
                speed = Speed(speedValue, speedUnit),
                degree = HexUtil.convertHexBytesToInt(byteArrayOf(bytes[8], bytes[9]))
            )
        } else null
    }

    companion object {
        fun isGoToHorizontalReply(bytes: ByteArray) = bytes.size == 9 &&
                bytes[3] == 0x4D.toByte() &&
                (bytes[4] == 0x23.toByte() || bytes[4] == 0x63.toByte())
    }
}