package app.pivo.android.podsdk.model.callback

import app.pivo.android.podsdk.model.*

/**
 * Created by murodjon on 2022/01/12
 */
class RegisteredCallbackAdapter : OnPodListener {

    private var batteryListener: OnBatteryListener? = null
    private var soundListener: OnBeamSoundListener? = null
    private var onOTAUpdateListener: OnOTAStatusListener? = null
    private var onMovementListener: OnMovementControlListener? = null
    private var onDeviceInfoListener: OnDeviceInfoListener? = null
    private var onConnectivityListener: OnConnectionControllerListener? = null
    private var onDeviceStatusListener: OnDeviceStatusListener? = null
    private var onRemoteControllerListener: OnRemoteControllerListener? = null
    private var onLEDListener: OnLEDListener? = null
    private var onAuthenticationListener: OnAuthenticationListener? = null

    constructor(listener: OnAuthenticationListener) {
        this.onAuthenticationListener = listener
    }

    constructor(listener: OnBatteryListener) {
        this.batteryListener = listener
    }

    constructor(listener: OnBeamSoundListener) {
        this.soundListener = listener
    }

    constructor(listener: OnConnectionControllerListener) {
        this.onConnectivityListener = listener
    }

    constructor(listener: OnDeviceInfoListener) {
        this.onDeviceInfoListener = listener
    }

    constructor(listener: OnMovementControlListener) {
        this.onMovementListener = listener
    }

    constructor(listener: OnOTAStatusListener) {
        this.onOTAUpdateListener = listener
    }

    constructor(listener: OnDeviceStatusListener) {
        this.onDeviceStatusListener = listener
    }

    constructor(listener: OnRemoteControllerListener) {
        this.onRemoteControllerListener = listener
    }

    constructor(listener: OnLEDListener) {
        this.onLEDListener = listener
    }

    override fun onBatteryReceived(level: Int) {
        batteryListener?.onBatteryReceived(level)
    }

    override fun onSound(soundType: SoundType) {
        soundListener?.onSound(soundType)
        onDeviceStatusListener?.onSound(soundType)
    }

    override fun onConnectionTimeoutReceived(timeout: Int) {
        onConnectivityListener?.onConnectionTimeoutReceived(timeout)
    }

    override fun onConnected() {
        onConnectivityListener?.onConnected()
    }

    override fun onConnectionFailed() {
        onConnectivityListener?.onConnectionFailed()
    }

    override fun onDiscovered(device: PivoDevice) {
        onConnectivityListener?.onDiscovered(device)
    }

    override fun onDeviceInfoReceived(deviceInfo: DeviceInfo) {
        onDeviceInfoListener?.onDeviceInfoReceived(deviceInfo)
    }

    override fun onMacAddressReceived(macAddress: String) {
        onDeviceInfoListener?.onMacAddressReceived(macAddress = macAddress)
    }

    override fun onSerialNumberReceived(serialNumber: String) {
        onDeviceInfoListener?.onSerialNumberReceived(serialNumber = serialNumber)
    }

    override fun onGetCurrentLED(led: CurrentLED) {
        onDeviceStatusListener?.onGetCurrentLED(led)
        onLEDListener?.onGetCurrentLED(led)
    }

    override fun onSetLED(led: SetLED) {
        onDeviceStatusListener?.onSetLED(led)
        onLEDListener?.onSetLED(led)
    }

    override fun onLEDPreset(patternType: LightPatternType, brightnessLevel: Int) {
        onDeviceStatusListener?.onLEDPreset(patternType, brightnessLevel)
        onLEDListener?.onLEDPreset(patternType, brightnessLevel)
    }

    override fun onLEDStopPreset() {
        onDeviceStatusListener?.onLEDStopPreset()
        onLEDListener?.onLEDStopPreset()
    }

    override fun onStop() {
        onMovementListener?.onStop()
    }

    override fun onMovingHorizontally(horizontalMovement: HorizontalMovement) {
        onMovementListener?.onMovingHorizontally(horizontalMovement)
    }

    override fun onMovingVertically(verticalMovement: VerticalMovement) {
        onMovementListener?.onMovingVertically(verticalMovement)
    }

    override fun onMovingOrthogonally(mixedMovement: MixedMovement) {
        onMovementListener?.onMovingOrthogonally(mixedMovement)
    }

    override fun onMovingNotification() {
        onMovementListener?.onMovingNotification()
    }

    override fun onVerticalPositionChanged(verticalPosition: GoToVerticalPosition) {
        onMovementListener?.onVerticalPositionChanged(verticalPosition)
    }

    override fun onHorizontalPositionChanged(horizontalPosition: GoToHorizontalPosition) {
        onMovementListener?.onHorizontalPositionChanged(horizontalPosition)
    }

    override fun onGetVerticalPosition(verticalPosition: VerticalPosition) {
        onMovementListener?.onGetVerticalPosition(verticalPosition)
    }

    override fun onGetHorizontalPosition(horizontalPosition: HorizontalPosition) {
        onMovementListener?.onGetHorizontalPosition(horizontalPosition)
    }

    override fun onSpeedChange(speed: ChangedSpeed) {
        onMovementListener?.onSpeedChange(speed)
    }

    override fun onResetPositionHorizontally() {
        onMovementListener?.onResetPositionHorizontally()
    }

    override fun onNameChanged(name: String) {
        onDeviceInfoListener?.onNameChanged(name = name)
    }

    override fun onInitiationFailed() {
        onOTAUpdateListener?.onInitiationFailed()
    }

    override fun onInitiated() {
        onOTAUpdateListener?.onInitiated()
    }

    override fun onOTAFailed() {
        onOTAUpdateListener?.onOTAFailed()
    }

    override fun onOTACompleted() {
        onOTAUpdateListener?.onOTACompleted()
    }

    override fun onOTAProgress(percentage: Double) {
        onOTAUpdateListener?.onOTAProgress(percentage)
    }

    override fun onRemoteConEvent(remoteConButton: RemoteConButton) {
        onRemoteControllerListener?.onRemoteConEvent(remoteConButton)
    }

    override fun onPairingStatus(status: PairingStatus) {
        onRemoteControllerListener?.onPairingStatus(status)
    }

    override fun onAuthenticated() {
        onAuthenticationListener?.onAuthenticated()
    }

    override fun onAuthenticationFailed() {
        onAuthenticationListener?.onAuthenticationFailed()
    }
}