package app.pivo.android.prosdk;

/**
 * Created by murodjon on 2020/11/11
 */
public enum RemoteButtonEvent {
    MODE(0, -1, Rotator.Speed.SPEED_1),
    CAMERA(0, -1, Rotator.Speed.SPEED_1),
    STOP(0, -1, Rotator.Speed.SPEED_1),
    LEFT_CONTINUOUS(0, -1, Rotator.Speed.SPEED_1),
    RIGHT_CONTINUOUS(0, -1, Rotator.Speed.SPEED_1),
    LEFT(0, -1, Rotator.Speed.SPEED_1),
    RIGHT(0, -1, Rotator.Speed.SPEED_1),
    SPEED_CHANGE(0, -1, Rotator.Speed.SPEED_1),
    OFF(0, -1, Rotator.Speed.SPEED_1);

    RemoteButtonEvent(int state, int direction, Rotator.Speed speed){
        this.state = state;
        this.direction = direction;
        this.speed = speed;
    }
    public int state;
    public int direction;
    public Rotator.Speed speed;

    public RemoteButtonEvent update(int state, int direction, Rotator.Speed speed){// 1 is "Up" and 0 is "Down";
        this.state = state;
        this.direction = direction;
        this.speed = speed;
        return this;
    }

    public RemoteButtonEvent update(int state, int direction){// 1 is "Up" and 0 is "Down";
        this.state = state;
        this.direction = direction;
        this.speed = Rotator.Speed.SPEED_1;
        return this;
    }
}
