package app.pivo.android.prosdk;

class SpeedConstraint {
    private static SpeedConstraint instance;

    private final Rotator.Speed[] speeds = PivoRotatorConfig.getInstance().getSpeeds();
    private final float [] angularSpeeds = PivoRotatorConfig.getInstance().getAngularSpeeds();

    public static SpeedConstraint getInstance (){
        if (instance ==null){
            instance = new SpeedConstraint();
            return instance;
        }
        return instance;
    }

    // Version 0
    Rotator.Speed constraint(float angle){
        int lower, upper;

        lower = PivoRotatorConfig.getInstance().getLowerIdx();
        upper = PivoRotatorConfig.getInstance().getUpperIdx();
        if (angle >=PivoRotatorConfig.getInstance().maxSpeed){
            return speeds[lower];
        } else if (angle<=PivoRotatorConfig.getInstance().minSpeed){
            return speeds[upper];
        }

        for (int i = lower; i < upper; i++) {
            float _upper = angularSpeeds[i];
            float _lower = angularSpeeds[i+1];

            if (angle < _upper && angle > _lower){
                float deltaToUpper = _upper - angle;
                float deltaToLower = _lower - angle;
                if (deltaToUpper < deltaToLower){
                    return speeds[i];
                }
                else {
                    return speeds[i+1];
                }
            }
        }

        return speeds[PivoRotatorConfig.getInstance().getMaxSpeedIndex()];
    }

    // Version 1
    int constraintAngle(float angle) {
        if (angle >= PivoRotatorConfig.getInstance().maxDegree) // E.g. 90 deg
            return (int)PivoRotatorConfig.getInstance().maxSpeed; // 4 sec/rnd --> speed 2
        return (int)(180.0f / angle); // speed 2
    }

}