package app.pivo.android.prosdk.util;

import androidx.annotation.NonNull;

import java.io.Serializable;

/**
 * Created by murodjon on 2021/09/02
 */
public class PivoDeviceInfo implements Serializable {
    /**
     * pivo device name
     */
    private String name;
    /**
     * pivo mac address
     */
    private String macAddress;
    /**
     * pivo serial number
     */
    private String serialNumber;
    /**
     * pivo version
     */
    private int version;
    /**
     * pivo type
     */
    private PivoType pivoType;

    /**
     * Pivo device default constructor
     */
    public PivoDeviceInfo() {
    }

    public PivoDeviceInfo(String name, String macAddress) {
        this.name = name;
        this.macAddress = macAddress;
    }

    public PivoDeviceInfo(String name, String macAddress, int version, PivoType pivoType, String serialNumber) {
        this.name = name;
        this.macAddress = macAddress;
        this.version = version;
        this.pivoType = pivoType;
        this.serialNumber = serialNumber;
    }

    /**
     * This get method is used to get name of Pivo
     *
     * @return string value
     */
    public String getName() {
        return name;
    }

    /**
     * This get method is used to get mac address of Pivo
     *
     * @return string value
     */
    public String getMacAddress() {
        return macAddress;
    }

    /**
     * This get method is used to get serial number of Pivo
     *
     * @return string value
     */
    public String getSerialNumber() {
        return serialNumber;
    }

    /**
     * This get method is used to get version of Pivo
     *
     * @return int value
     */
    public int getVersion() {
        return version;
    }

    /**
     * This get method is used to get pivo type
     *
     * @return PivoType value
     */
    public PivoType getPivoType() {
        return pivoType;
    }


    @NonNull
    @Override
    public String toString() {
        return String.format("PivoDeviceInfo(name=%s, macAddress=%s, serialNumber=%s, version=%s, pivoType=%s)", name, macAddress, serialNumber, version, pivoType);
    }
}