package app.pivo.android.prosdk.util;

/**
 *
 * {@link Version} is a model which contains version and type of Pivo device.
 */
public class Version {

    private final int version;
    private final PivoType pivoType;

    public Version(int version, PivoType pivoType){
        this.pivoType = pivoType;
        this.version = version;
    }

    public PivoType getPivoType(){
        return pivoType;
    }

    public int getVersion(){
        return version;
    }

    public boolean isAboveV1(){
        return version>1;
    }

    public boolean isAboveV0(){
        return version>0;
    }

    public boolean isV0(){
        return version == 0;
    }
}
