package app.ringify.repositories.notifications

import app.ringify.client.IRingifyClient
import app.ringify.models.notifications.CreateNotificationTokenPayload
import app.ringify.models.notifications.NotificationToken
import app.ringify.models.users.User
import dev.kaccelero.models.RecursiveId
import dev.kaccelero.models.UUID
import dev.kaccelero.repositories.APIChildModelRemoteRepository
import dev.kaccelero.repositories.IAPIChildModelRemoteRepository
import io.ktor.util.reflect.*

class NotificationTokensRemoteRepository(
    client: IRingifyClient,
    parentRepository: IAPIChildModelRemoteRepository<User, UUID, *, *, *>,
) : APIChildModelRemoteRepository<NotificationToken, String, CreateNotificationTokenPayload, Unit, UUID>(
    typeInfo<NotificationToken>(),
    typeInfo<CreateNotificationTokenPayload>(),
    typeInfo<Unit>(),
    typeInfo<List<NotificationToken>>(),
    client,
    parentRepository,
    prefix = "/api/v1"
), INotificationTokensRemoteRepository {

    override suspend fun create(payload: CreateNotificationTokenPayload, userId: UUID): NotificationToken? =
        create(payload, RecursiveId<User, UUID, Unit>(userId), null)

}
