package app.ringify.repositories.regions

import app.ringify.client.IRingifyClient
import app.ringify.models.regions.CreateRegionPayload
import app.ringify.models.regions.Region
import dev.kaccelero.models.RecursiveId
import dev.kaccelero.models.UUID
import dev.kaccelero.models.UnitModel
import dev.kaccelero.repositories.APIModelRemoteRepository
import io.ktor.client.call.*
import io.ktor.http.*
import io.ktor.util.reflect.*

class RegionsRemoteRepository(
    client: IRingifyClient,
) : APIModelRemoteRepository<Region, UUID, CreateRegionPayload, Unit>(
    typeInfo<Region>(),
    typeInfo<CreateRegionPayload>(),
    typeInfo<Unit>(),
    typeInfo<List<Region>>(),
    client,
    prefix = "/api/v1"
), IRegionsRemoteRepository {

    override suspend fun get(id: UUID): Region? = get(id, null)

    override suspend fun getByTypeAndIdentifier(type: String, identifier: String): Region? = client
        .request(HttpMethod.Post, "${constructFullRoute(RecursiveId<UnitModel, Unit, Unit>(Unit))}/$type/$identifier")
        .body()

}

