package app.ringify.repositories.regions

import app.ringify.client.IRingifyClient
import app.ringify.models.regions.CreateUserInRegionPayload
import app.ringify.models.regions.Region
import app.ringify.models.regions.UserInRegion
import dev.kaccelero.models.RecursiveId
import dev.kaccelero.models.UUID
import dev.kaccelero.repositories.APIChildModelRemoteRepository
import dev.kaccelero.repositories.IAPIChildModelRemoteRepository
import io.ktor.util.reflect.*

class UsersInRegionsRemoteRepository(
    client: IRingifyClient,
    parentRepository: IAPIChildModelRemoteRepository<Region, UUID, *, *, *>,
) : APIChildModelRemoteRepository<UserInRegion, UUID, CreateUserInRegionPayload, Unit, UUID>(
    typeInfo<UserInRegion>(),
    typeInfo<CreateUserInRegionPayload>(),
    typeInfo<Unit>(),
    typeInfo<List<UserInRegion>>(),
    client,
    parentRepository,
    route = "users",
    prefix = "/api/v1"
), IUsersInRegionsRemoteRepository {

    override suspend fun list(teamId: UUID): List<UserInRegion> =
        list(RecursiveId<Region, UUID, Unit>(teamId), null)

    override suspend fun create(payload: CreateUserInRegionPayload, teamId: UUID): UserInRegion? =
        create(payload, RecursiveId<Region, UUID, Unit>(teamId), null)

    override suspend fun delete(userId: UUID, teamId: UUID): Boolean =
        delete(userId, RecursiveId<Region, UUID, Unit>(teamId), null)

}
