package app.ringify.models.teams

import app.ringify.models.users.User
import dev.kaccelero.models.IChildModel
import dev.kaccelero.models.UUID
import kotlinx.serialization.Serializable

@Serializable
data class UserInTeam(
    val userId: UUID,
    val teamId: UUID,
    val isAdmin: Boolean,
    val user: User? = null,
    val team: Team? = null,
) : IChildModel<UUID, CreateUserInTeamPayload, Unit, UUID> {

    override val id: UUID
        get() = userId

    override val parentId: UUID
        get() = teamId

}
