package app.ringify.models.entries

import dev.kaccelero.annotations.Schema
import dev.kaccelero.models.IChildModel
import dev.kaccelero.models.UUID
import kotlinx.datetime.LocalDate
import kotlinx.serialization.Serializable

@Serializable
data class Entry(
    @Schema("Id of the user owning the entry", "123abc")
    val userId: UUID,
    @Schema("Date of the entry", "2021-01-01")
    val date: LocalDate,
    @Schema("Value of the move ring", "0")
    val move: Int,
    @Schema("Value of the exercise ring", "0")
    val exercise: Int,
    @Schema("Value of the stand ring", "0")
    val stand: Int,
) : IChildModel<LocalDate, EntryPayload, EntryPayload, UUID> {

    override val id: LocalDate
        get() = date

    override val parentId: UUID
        get() = userId

}
