package app.ringify.repositories.users

import app.ringify.client.IRingifyClient
import app.ringify.models.duels.Duel
import app.ringify.models.regions.UserInRegion
import app.ringify.models.teams.UserInTeam
import app.ringify.models.users.CreateUserPayload
import app.ringify.models.users.UpdateUserPayload
import app.ringify.models.users.User
import dev.kaccelero.models.RecursiveId
import dev.kaccelero.models.UUID
import dev.kaccelero.models.UnitModel
import dev.kaccelero.repositories.APIModelRemoteRepository
import io.ktor.client.call.*
import io.ktor.http.*
import io.ktor.util.reflect.*

class UsersRemoteRepository(
    client: IRingifyClient,
) : APIModelRemoteRepository<User, UUID, CreateUserPayload, UpdateUserPayload>(
    typeInfo<User>(),
    typeInfo<CreateUserPayload>(),
    typeInfo<UpdateUserPayload>(),
    typeInfo<List<User>>(),
    client,
    prefix = "/api/v1"
), IUsersRemoteRepository {

    override suspend fun get(id: UUID): User? = get(id, null)

    override suspend fun update(id: UUID, payload: UpdateUserPayload): User? = update(id, payload, null)

    override suspend fun delete(id: UUID) = delete(id, null)

    override suspend fun listRegions(id: UUID): List<UserInRegion> = client
        .request(HttpMethod.Get, "${constructFullRoute(RecursiveId<UnitModel, Unit, Unit>(Unit))}/$id/regions")
        .body()

    override suspend fun listTeams(id: UUID): List<UserInTeam> = client
        .request(HttpMethod.Get, "${constructFullRoute(RecursiveId<UnitModel, Unit, Unit>(Unit))}/$id/teams")
        .body()

    override suspend fun listDuels(id: UUID): List<Duel> = client
        .request(HttpMethod.Get, "${constructFullRoute(RecursiveId<UnitModel, Unit, Unit>(Unit))}/$id/duels")
        .body()

    override suspend fun listEndedDuels(id: UUID): List<Duel> = client
        .request(HttpMethod.Get, "${constructFullRoute(RecursiveId<UnitModel, Unit, Unit>(Unit))}/$id/duels/ended")
        .body()

    override suspend fun listPendingDuels(id: UUID): List<Duel> = client
        .request(HttpMethod.Get, "${constructFullRoute(RecursiveId<UnitModel, Unit, Unit>(Unit))}/$id/duels/pending")
        .body()

}
