package app.ringify.models.regions

import app.ringify.models.users.User
import dev.kaccelero.models.IChildModel
import dev.kaccelero.models.UUID
import kotlinx.serialization.Serializable

@Serializable
data class UserInRegion(
    val userId: UUID,
    val regionId: UUID,
    val user: User? = null,
    val region: Region? = null,
) : IChildModel<UUID, CreateUserInRegionPayload, Unit, UUID> {

    override val id: UUID
        get() = userId

    override val parentId: UUID
        get() = regionId

}
