package app.ringify.models.regions

import app.ringify.models.application.ILeaderboard
import dev.kaccelero.annotations.Schema
import dev.kaccelero.models.IModel
import dev.kaccelero.models.UUID
import kotlinx.serialization.Serializable

@Serializable
data class Region(
    @Schema("Id of the Region", "123abc")
    override val id: UUID,
    @Schema("Type of the Region", "COUNTRY")
    val type: RegionType,
    @Schema("Identifier of the Region", "FR")
    val identifier: String,
    @Schema("Name of the Region", "France")
    override val name: String,
) : IModel<UUID, CreateRegionPayload, Unit>, ILeaderboard
