package app.ringify.models.watchers

import dev.kaccelero.annotations.Schema
import dev.kaccelero.models.IChildModel
import dev.kaccelero.models.UUID
import kotlinx.serialization.Serializable

@Serializable
data class Watcher(
    @Schema("The user watching the target")
    val sourceId: UUID,
    @Schema("The target being watched")
    val targetId: UUID,
) : IChildModel<UUID, CreateWatcherPayload, Unit, UUID> {

    override val id: UUID
        get() = sourceId

    override val parentId: UUID
        get() = targetId

}
