package app.ringify.models.users

import dev.kaccelero.annotations.Schema
import dev.kaccelero.models.IModel
import dev.kaccelero.models.IUser
import dev.kaccelero.models.UUID
import kotlinx.serialization.Serializable

@Serializable
data class User(
    @Schema("Id of the User", "123abc")
    override val id: UUID,
    @Schema("Name of the User", "Nathan")
    val name: String,
    @Schema("Avatar of the User", "https://...")
    val avatar: String,
    @Schema("Number of ended duels")
    val endedDuelsCount: Long? = null,
    @Schema("Number of won duels")
    val wonDuelsCount: Long? = null,
    @Schema("If the current user is watching this user")
    val isWatchedByMe: Boolean? = null,
) : IModel<UUID, CreateUserPayload, UpdateUserPayload>, IUser
