/*
 * Decompiled with CFR 0.152.
 */
package app.ringify.client;

import app.ringify.client.IRingifyClient;
import app.ringify.models.application.RingifyEnvironment;
import app.ringify.repositories.auth.AuthAPIRemoteRepository;
import app.ringify.repositories.duels.DuelsRemoteRepository;
import app.ringify.repositories.entries.EntriesRemoteRepository;
import app.ringify.repositories.notifications.NotificationTokensRemoteRepository;
import app.ringify.repositories.regions.RegionsRemoteRepository;
import app.ringify.repositories.regions.UsersInRegionsRemoteRepository;
import app.ringify.repositories.teams.TeamsRemoteRepository;
import app.ringify.repositories.teams.UsersInTeamsRemoteRepository;
import app.ringify.repositories.users.UsersRemoteRepository;
import app.ringify.repositories.watchers.WatchersRemoteRepository;
import dev.kaccelero.client.AbstractAPIClient;
import dev.kaccelero.commons.auth.IGetTokenUseCase;
import dev.kaccelero.commons.auth.ILogoutUseCase;
import dev.kaccelero.commons.auth.IRenewTokenUseCase;
import dev.kaccelero.repositories.IAPIChildModelRemoteRepository;
import io.ktor.http.HttpMethod;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u008a\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B)\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\b\b\u0002\u0010\t\u001a\u00020\n\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0018\u00105\u001a\u0002062\u0006\u00107\u001a\u0002082\u0006\u00109\u001a\u00020:H\u0016R\u0014\u0010\r\u001a\u00020\u000eX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0011\u001a\u00020\u0012X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0014\u0010\u0015\u001a\u00020\u0016X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0014\u0010\u0019\u001a\u00020\u001aX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u0014\u0010\u001d\u001a\u00020\u001eX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 R\u0014\u0010!\u001a\u00020\"X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010$R\u0014\u0010%\u001a\u00020&X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010(R\u0014\u0010)\u001a\u00020*X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b+\u0010,R\u0014\u0010-\u001a\u00020.X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b/\u00100R\u0014\u00101\u001a\u000202X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b3\u00104\u00a8\u0006;"}, d2={"Lapp/ringify/client/RingifyClient;", "Ldev/kaccelero/client/AbstractAPIClient;", "Lapp/ringify/client/IRingifyClient;", "getTokenUseCase", "Ldev/kaccelero/commons/auth/IGetTokenUseCase;", "renewTokenUseCase", "Ldev/kaccelero/commons/auth/IRenewTokenUseCase;", "logoutUseCase", "Ldev/kaccelero/commons/auth/ILogoutUseCase;", "environment", "Lapp/ringify/models/application/RingifyEnvironment;", "<init>", "(Ldev/kaccelero/commons/auth/IGetTokenUseCase;Ldev/kaccelero/commons/auth/IRenewTokenUseCase;Ldev/kaccelero/commons/auth/ILogoutUseCase;Lapp/ringify/models/application/RingifyEnvironment;)V", "auth", "Lapp/ringify/repositories/auth/AuthAPIRemoteRepository;", "getAuth", "()Lapp/ringify/repositories/auth/AuthAPIRemoteRepository;", "users", "Lapp/ringify/repositories/users/UsersRemoteRepository;", "getUsers", "()Lapp/ringify/repositories/users/UsersRemoteRepository;", "duels", "Lapp/ringify/repositories/duels/DuelsRemoteRepository;", "getDuels", "()Lapp/ringify/repositories/duels/DuelsRemoteRepository;", "entries", "Lapp/ringify/repositories/entries/EntriesRemoteRepository;", "getEntries", "()Lapp/ringify/repositories/entries/EntriesRemoteRepository;", "notificationTokens", "Lapp/ringify/repositories/notifications/NotificationTokensRemoteRepository;", "getNotificationTokens", "()Lapp/ringify/repositories/notifications/NotificationTokensRemoteRepository;", "regions", "Lapp/ringify/repositories/regions/RegionsRemoteRepository;", "getRegions", "()Lapp/ringify/repositories/regions/RegionsRemoteRepository;", "usersInRegions", "Lapp/ringify/repositories/regions/UsersInRegionsRemoteRepository;", "getUsersInRegions", "()Lapp/ringify/repositories/regions/UsersInRegionsRemoteRepository;", "teams", "Lapp/ringify/repositories/teams/TeamsRemoteRepository;", "getTeams", "()Lapp/ringify/repositories/teams/TeamsRemoteRepository;", "usersInTeams", "Lapp/ringify/repositories/teams/UsersInTeamsRemoteRepository;", "getUsersInTeams", "()Lapp/ringify/repositories/teams/UsersInTeamsRemoteRepository;", "watchers", "Lapp/ringify/repositories/watchers/WatchersRemoteRepository;", "getWatchers", "()Lapp/ringify/repositories/watchers/WatchersRemoteRepository;", "shouldIncludeToken", "", "method", "Lio/ktor/http/HttpMethod;", "path", "", "commons"})
public final class RingifyClient
extends AbstractAPIClient
implements IRingifyClient {
    @NotNull
    private final AuthAPIRemoteRepository auth;
    @NotNull
    private final UsersRemoteRepository users;
    @NotNull
    private final DuelsRemoteRepository duels;
    @NotNull
    private final EntriesRemoteRepository entries;
    @NotNull
    private final NotificationTokensRemoteRepository notificationTokens;
    @NotNull
    private final RegionsRemoteRepository regions;
    @NotNull
    private final UsersInRegionsRemoteRepository usersInRegions;
    @NotNull
    private final TeamsRemoteRepository teams;
    @NotNull
    private final UsersInTeamsRemoteRepository usersInTeams;
    @NotNull
    private final WatchersRemoteRepository watchers;

    public RingifyClient(@NotNull IGetTokenUseCase getTokenUseCase, @NotNull IRenewTokenUseCase renewTokenUseCase, @NotNull ILogoutUseCase logoutUseCase, @NotNull RingifyEnvironment environment) {
        Intrinsics.checkNotNullParameter((Object)getTokenUseCase, (String)"getTokenUseCase");
        Intrinsics.checkNotNullParameter((Object)renewTokenUseCase, (String)"renewTokenUseCase");
        Intrinsics.checkNotNullParameter((Object)logoutUseCase, (String)"logoutUseCase");
        Intrinsics.checkNotNullParameter((Object)((Object)environment), (String)"environment");
        super(environment.getBaseUrl(), getTokenUseCase, renewTokenUseCase, logoutUseCase, null, null, 48, null);
        this.auth = new AuthAPIRemoteRepository(this);
        this.users = new UsersRemoteRepository(this);
        this.duels = new DuelsRemoteRepository(this);
        this.entries = new EntriesRemoteRepository(this, (IAPIChildModelRemoteRepository)this.getUsers());
        this.notificationTokens = new NotificationTokensRemoteRepository(this, (IAPIChildModelRemoteRepository)this.getUsers());
        this.regions = new RegionsRemoteRepository(this);
        this.usersInRegions = new UsersInRegionsRemoteRepository(this, (IAPIChildModelRemoteRepository)this.getRegions());
        this.teams = new TeamsRemoteRepository(this);
        this.usersInTeams = new UsersInTeamsRemoteRepository(this, (IAPIChildModelRemoteRepository)this.getTeams());
        this.watchers = new WatchersRemoteRepository(this, (IAPIChildModelRemoteRepository)this.getUsers());
    }

    public /* synthetic */ RingifyClient(IGetTokenUseCase iGetTokenUseCase, IRenewTokenUseCase iRenewTokenUseCase, ILogoutUseCase iLogoutUseCase, RingifyEnvironment ringifyEnvironment, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            ringifyEnvironment = RingifyEnvironment.PRODUCTION;
        }
        this(iGetTokenUseCase, iRenewTokenUseCase, iLogoutUseCase, ringifyEnvironment);
    }

    @Override
    @NotNull
    public AuthAPIRemoteRepository getAuth() {
        return this.auth;
    }

    @Override
    @NotNull
    public UsersRemoteRepository getUsers() {
        return this.users;
    }

    @Override
    @NotNull
    public DuelsRemoteRepository getDuels() {
        return this.duels;
    }

    @Override
    @NotNull
    public EntriesRemoteRepository getEntries() {
        return this.entries;
    }

    @Override
    @NotNull
    public NotificationTokensRemoteRepository getNotificationTokens() {
        return this.notificationTokens;
    }

    @Override
    @NotNull
    public RegionsRemoteRepository getRegions() {
        return this.regions;
    }

    @Override
    @NotNull
    public UsersInRegionsRemoteRepository getUsersInRegions() {
        return this.usersInRegions;
    }

    @Override
    @NotNull
    public TeamsRemoteRepository getTeams() {
        return this.teams;
    }

    @Override
    @NotNull
    public UsersInTeamsRemoteRepository getUsersInTeams() {
        return this.usersInTeams;
    }

    @Override
    @NotNull
    public WatchersRemoteRepository getWatchers() {
        return this.watchers;
    }

    public boolean shouldIncludeToken(@NotNull HttpMethod method, @NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        return !Intrinsics.areEqual((Object)path, (Object)"/api/v1/auth/refresh");
    }
}

