package app.ringify.client

import app.ringify.models.application.RingifyEnvironment
import app.ringify.repositories.auth.AuthAPIRemoteRepository
import app.ringify.repositories.duels.DuelsRemoteRepository
import app.ringify.repositories.entries.EntriesRemoteRepository
import app.ringify.repositories.notifications.NotificationTokensRemoteRepository
import app.ringify.repositories.teams.TeamsRemoteRepository
import app.ringify.repositories.teams.UsersInTeamsRemoteRepository
import app.ringify.repositories.users.UsersRemoteRepository
import app.ringify.repositories.watchers.WatchersRemoteRepository
import dev.kaccelero.client.AbstractAPIClient
import dev.kaccelero.commons.auth.IGetTokenUseCase
import dev.kaccelero.commons.auth.ILogoutUseCase
import dev.kaccelero.commons.auth.IRenewTokenUseCase

class RingifyClient(
    getTokenUseCase: IGetTokenUseCase,
    renewTokenUseCase: IRenewTokenUseCase,
    logoutUseCase: ILogoutUseCase,
    environment: RingifyEnvironment = RingifyEnvironment.PRODUCTION,
) : AbstractAPIClient(
    environment.baseUrl,
    getTokenUseCase,
    renewTokenUseCase,
    logoutUseCase
), IRingifyClient {

    override val auth = AuthAPIRemoteRepository(this)
    override val users = UsersRemoteRepository(this)
    override val duels = DuelsRemoteRepository(this)
    override val entries = EntriesRemoteRepository(this, users)
    override val notificationTokens = NotificationTokensRemoteRepository(this, users)
    override val teams = TeamsRemoteRepository(this)
    override val usersInTeams = UsersInTeamsRemoteRepository(this, teams)
    override val watchers = WatchersRemoteRepository(this, users)

}
