package app.ringify.models.teams

import app.ringify.models.application.ILeaderboard
import dev.kaccelero.annotations.Schema
import dev.kaccelero.models.IModel
import dev.kaccelero.models.UUID
import kotlinx.serialization.Serializable

@Serializable
data class Team(
    @Schema("Id of the Team", "123abc")
    override val id: UUID,
    @Schema("Name of the Team", "Team")
    override val name: String,
    @Schema("If the Team is public or not", "true")
    val isPublic: Boolean,
    @Schema("Number of users in the Team", "5")
    val usersCount: Long,
    @Schema("Is current user a member of the team?", "true")
    val isMember: Boolean?,
) : IModel<UUID, CreateTeamPayload, UpdateTeamPayload>, ILeaderboard
