package app.ringify.repositories.entries

import app.ringify.client.IRingifyClient
import app.ringify.models.entries.BatchEntryPayload
import app.ringify.models.entries.Entry
import app.ringify.models.entries.EntryPayload
import app.ringify.models.users.User
import dev.kaccelero.models.RecursiveId
import dev.kaccelero.models.UUID
import dev.kaccelero.repositories.APIChildModelRemoteRepository
import dev.kaccelero.repositories.IAPIChildModelRemoteRepository
import io.ktor.client.call.*
import io.ktor.client.request.*
import io.ktor.http.*
import io.ktor.util.reflect.*
import kotlinx.datetime.LocalDate

class EntriesRemoteRepository(
    client: IRingifyClient,
    parentRepository: IAPIChildModelRemoteRepository<User, UUID, *, *, *>,
) : APIChildModelRemoteRepository<Entry, LocalDate, EntryPayload, EntryPayload, UUID>(
    typeInfo<Entry>(),
    typeInfo<EntryPayload>(),
    typeInfo<EntryPayload>(),
    typeInfo<List<Entry>>(),
    client,
    parentRepository,
    prefix = "/api/v1",
    route = "entries"
), IEntriesRemoteRepository {

    override suspend fun create(payload: EntryPayload, userId: UUID): Entry? =
        create(payload, RecursiveId<User, UUID, Unit>(userId), null)

    override suspend fun createBatch(payload: BatchEntryPayload, userId: UUID): List<Entry> =
        client.request(HttpMethod.Post, constructFullRoute(RecursiveId<User, UUID, Unit>(userId))) {
            contentType(ContentType.Application.Json)
            setBody(payload)
        }.body()


}
