package app.ringify.repositories.duels

import app.ringify.models.duels.CreateDuelPayload
import app.ringify.models.duels.Duel
import app.ringify.models.entries.Entry
import dev.kaccelero.models.UUID

interface IDuelsRemoteRepository {

    suspend fun get(id: UUID): Duel?
    suspend fun create(payload: CreateDuelPayload): Duel?
    suspend fun accept(id: UUID): Duel?
    suspend fun decline(id: UUID): Boolean
    suspend fun listEntries(id: UUID): List<Entry>

}
